﻿/// <reference name="MicrosoftAjax.js">
Number.parseLocaleFixed = function(value) {
    return Number.parseLocale(value.replace(" "," "));
} 

function checkAmounts() {
    var fromAmount = $find("FromCurrencyTextBox");
    var unFormattedFrom = fromAmount.get_unFormattedValue();
    var formattedFrom = null;
    
    if (unFormattedFrom !== null && unFormattedFrom !== "") {
        formattedFrom = Number.parseLocaleFixed(unFormattedFrom);
        if (isNaN(formattedFrom)) {
            alert (String.format(Filter.Res.InvalidCurrencyFilterMessage, Filter.Res.FromAmount));
            return false;
        }
    }
    
    var toAmount = $find("ToCurrencyTextBox");
    var unFormattedTo = toAmount.get_unFormattedValue();
    var formattedTo = null;
    
    if (unFormattedTo !== null && unFormattedTo !== "") {
        formattedTo = Number.parseLocaleFixed(unFormattedTo);
        if (isNaN(formattedTo))
        {
            alert (String.format(Filter.Res.InvalidCurrencyFilterMessage, Filter.Res.ToAmount));
            return false;
        }
    }
    
    if (formattedFrom !== null && formattedTo !== null) {
        if (formattedFrom > formattedTo) {
            alert (Filter.Res.FromAmountGreaterThanToAmountMessage);
            return false;
        }
    }
  
    return true;
}

Type.registerNamespace("Filter");
Filter.Res =  {
    FromAmount: "From Amount",
    InvalidCurrencyFilterMessage: "The filter can't be applied because the '{0}' is not a valid number.",
    ToAmount: "To Amount",
    FromAmountGreaterThanToAmountMessage: "The From Amount must be less than or equal to the To Amount."
}